"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var html_node_1 = require("./html-node");
/**
 * @class Autolinker.htmlParser.TextNode
 * @extends Autolinker.htmlParser.HtmlNode
 *
 * Represents a text node that has been parsed by the {@link Autolinker.htmlParser.HtmlParser}.
 *
 * See this class's superclass ({@link Autolinker.htmlParser.HtmlNode}) for more
 * details.
 */
var TextNode = /** @class */ (function (_super) {
    tslib_1.__extends(TextNode, _super);
    function TextNode() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Returns a string name for the type of node that this class represents.
     *
     * @return {String}
     */
    TextNode.prototype.getType = function () {
        return 'text';
    };
    return TextNode;
}(html_node_1.HtmlNode));
exports.TextNode = TextNode;

//# sourceMappingURL=text-node.js.map
